%------------------------------------------------------------------------------
% File     : SWV429^1 : TPTP v7.4.0. Released v3.6.0.
% Domain   : Software Verification (Security)
% Problem  : ICL^=> logic mapping to modal logic implies 'refl'
% Version  : [Ben08] axioms.
% English  :

% Refs     : [GA08]  Garg & Abadi (2008), A Modal Deconstruction of Access
%          : [Ben08] Benzmueller (2008), Automating Access Control Logics i
%          : [BP09]  Benzmueller & Paulson (2009), Exploring Properties of
% Source   : [Ben08]
% Names    :

% Status   : Theorem
% Rating   : 0.00 v7.1.0, 0.12 v7.0.0, 0.00 v6.2.0, 0.14 v6.1.0, 0.00 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v4.1.0, 0.00 v4.0.0, 0.33 v3.7.0
% Syntax   : Number of formulae    :   58 (   0 unit;  32 type;  25 defn)
%            Number of atoms       :  132 (  25 equality;  53 variable)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   59 (   3   ~;   1   |;   2   &;  52   @)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  130 ( 130   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   37 (  32   :;   0   =)
%            Number of variables   :   49 (   2 sgn;   4   !;   4   ?;  41   ^)
%                                         (  49   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
%----Include axioms of multi modal logic
include('Axioms/LCL008^0.ax').
%----Include axioms of ICL logic
include('Axioms/SWV008^0.ax').
%----Include axioms of ICL^=> logic
include('Axioms/SWV008^2.ax').
%------------------------------------------------------------------------------
%----We introduce an arbitrary principal a
thf(a,type,(
    a: $i > $o )).

%----Can we prove 'refl'?
thf(conj,conjecture,
    ( iclval @ ( icl_impl_princ @ ( icl_princ @ a ) @ ( icl_princ @ a ) ) )).

%------------------------------------------------------------------------------
